<?php

use App\Http\Controllers\AboutController;
use App\Http\Controllers\AccountController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\CategoryController;
use App\Http\Controllers\FactController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\MessageController;
use App\Http\Controllers\ProjectController;
use App\Http\Controllers\ResumeController;
use App\Http\Controllers\ServiceController;
use App\Http\Controllers\SkillController;
use App\Http\Controllers\SocialController;
use App\Http\Controllers\TestimonialController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/


Route::get('/',[HomeController::class,'home']);
//auth
Route::get('/login', [AuthController::class,'showLogin']);
Route::post('/login', [AuthController::class,'login'])->name('login');
// Route::get('/register', [AuthController::class,'showRegister']);
// Route::post('/register', [AuthController::class,'register']);
Route::get('/logout', [AuthController::class,'logout']);

Route::resource('account',AccountController::class);
Route::resource('about',AboutController::class);
Route::resource('fact',FactController::class);
Route::resource('skill',SkillController::class);
Route::resource('social',SocialController::class);
Route::resource('testimonial',TestimonialController::class);
Route::resource('resume',ResumeController::class);
Route::resource('service',ServiceController::class);
Route::resource('project',ProjectController::class);
Route::resource('category',CategoryController::class);
Route::resource('message',MessageController::class);

Route::get('projects/{slug}',[HomeController::class,'pjshow'])->name('pj.show');
Route::get('/dashboard', [DashboardController::class,'show'])->name('dashboard')->middleware('auth');
Route::get('/others', [DashboardController::class,'about'])->name('about')->middleware('auth');
