<?php

namespace App\Http\Controllers;

use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use PDO;

class AuthController extends Controller
{
    public function showLogin()
    {
        return view('auth.login');
    }

    public function login(Request $request)
    {
        $email = $request->email;
        $password = $request->password;
        //check email
        $emailExist = User::where('email', $email)->first();
        if (!$emailExist) {
            return redirect()->back()->with('error', 'Email Not Found.');
        }
        
        //check password
        $checkAuth =  Auth::attempt($request->only('email', 'password'));
        if (!$checkAuth) {
            return redirect()->back()->with('error', 'Wrong Password.');
        }

        return redirect(route('dashboard'))->with('success', 'Welcome ' . auth()->user()->name);
    }


    public function showRegister()
    {
        return view('auth.register');
    }

    public function register(Request $request)
    {
        $request->validate([
            'name' => "required",
            'email' => 'required|email',
            'password' => "required|min:3",
        ]);
        $email = $request->email;
        $emailExist = User::where('email', $email)->first();
        if ($emailExist) {
            return redirect()->back()->with('error', 'Email Already Exist');
        }

        $createdUser = User::create([
            'name' => $request->name,
            'email' => $request->email,
            'password' => Hash::make($request->password),
        ]);

        auth()->login($createdUser);
        return redirect(route('dashboard'))->with('success', 'Account Created Success.');
    }
    public function logout()
    {
        auth()->logout();
        return redirect('/login')->with('success', 'Logout Success.');
    }
}
