<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Blood Donor</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-9ndCyUaIbzAi2FUVXJi0CjmCapSmO7SnpJef0486qhLnuZ2cdeRhO02iuK6FUUVM" crossorigin="anonymous">
</head>

<body class="bg-dark text-warning">
    <nav class="navbar navbar-expand-lg bg-body-tertiary">
        <div class="container-fluid container d-flex justify-content-between ">
            <div class="navbar-brand" href="#">Blood Donor</div>
            <div>
                <form class="d-flex" role="search" method="get">

                    <select class="form-select" name="type_id">
                        <option class="text-warning" value="">Blood type</option>
                        <?php $__currentLoopData = $types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $d): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option class="text-warning" value="<?php echo e($d->id); ?>"><?php echo e($d->type); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    <button class="btn btn-outline-success" type="submit">Search</button>
                </form>
            </div>
        </div>
    </nav>

    <div class="container">

        <table class="table table-striped ">
            <thead>
                <tr>
                    <th scope="col">No</th>
                    <th scope="col">Name</th>
                    <th scope="col">Type</th>
                    <th scope="col">Phone</th>
                    <th scope="col">Times</th>
                    <th scope="col">Last time donation date</th>
                    <th scope="col">Options</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $donors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $donor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <th scope="row"><?php echo e(++$key); ?></th>
                        <td><?php echo e($donor->name); ?></td>
                        <td><?php echo e($donor->type->type); ?></td>
                        <td><a href="tel:<?php echo e($donor->phone); ?>"><?php echo e($donor->phone); ?></a></td>
                        <?php
                            if (isset($donor->transition)) {
                                $array = $donor->transition;
                                $lastItem = null;
                                if (count($array) > 0) {
                                    $lastItem = $array[count($array) - 1];
                                }
                            }
                        ?>
                        <td><?php echo e(isset($array) ? count($array) : '0'); ?></td>
                        <td><?php echo e(isset($lastItem) ? $lastItem->created_at->format('d-m-Y') : 'No Data'); ?>

                            <br>
                            <?php echo e(isset($lastItem) ? $lastItem->receiver : ''); ?>

                            <br>
                            <?php if(isset($lastItem) && now()->diffInDays($lastItem->created_at) > 120): ?>
                                Available
                            <?php elseif(!isset($lastItem)): ?>
                                Available
                            <?php else: ?>
                                Not Available.
                                <?php echo e(isset($lastItem) ? 120 - now()->diffInDays($lastItem->created_at) : ''); ?> Days laft.
                            <?php endif; ?>

                        </td>
                        <td>
                            <button type="button" class="btn btn-primary" data-bs-toggle="modal"
                                data-bs-target="#create<?php echo e($donor->id); ?>">
                                Donate
                            </button>
                            <a href="<?php echo e(route('donor.show', $donor->id)); ?>" class="btn btn-warning">View</a>
                        </td>
                    </tr>

                    <!-- Modal -->
                    <div class="modal fade text-dark" id="create<?php echo e($donor->id); ?>" tabindex="-1"
                        aria-labelledby="exampleModalLabel" aria-hidden="true">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h1 class="modal-title fs-5" id="exampleModalLabel">Create Donation</h1>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                        aria-label="Close"></button>
                                </div>
                                <div class="modal-body">
                                    <form action="<?php echo e(route('transition.store')); ?>" method="post">
                                        <?php echo csrf_field(); ?>
                                        <input type="hidden" class="form-control"
                                            value="<?php echo e($donor->id); ?>"name="donor_id">
                                        <div class="mb-3">
                                            <label class="form-label">Date</label>
                                            <input type="date" name="created_at" required>
                                        </div>
                                        <div class="mb-3">
                                            <label class="form-label">Receiver</label>
                                            <input class="form-control" name="receiver" required>
                                        </div>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary"
                                        data-bs-dismiss="modal">Close</button>
                                    <button type="submit" class="btn btn-primary">Save changes</button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
        <?php echo e($donors->links()); ?>

    </div>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"
        integrity="sha384-geWF76RCwLtnZ8qwWowPQNguL3RmwHVBC9FhGdlKrxdiJJigb/j/68SIy3Te4Bkz" crossorigin="anonymous">
    </script>
</body>

</html>
<?php /**PATH C:\Users\devel\Workspace\blood\resources\views/welcome.blade.php ENDPATH**/ ?>