<?php

namespace App\Http\Controllers;

use App\Models\Donor;
use App\Models\Transition;
use App\Models\Type;
use Illuminate\Http\Request;

class TypeController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {   
        $donors =Donor::with('transition')->orderBy('donationdate')->paginate(30);
        if($request->type_id){
            $donors = Donor::where('type_id', $request->type_id)->with('transition')->orderBy('donationdate')->paginate(30);
            
            $donors->appends($request->all()); // add this line to append query params
        };
        return view('welcome',[
            'types' => Type::all(),
            'donors' => $donors
        ]);
        
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        
        return view('create',[
            'types' => Type::all(),
            'donors' => Donor::all()
        ]);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(Type $type)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Type $type)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Type $type)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Type $type)
    {
        //
    }
}
