@extends('admin.layout.master')

@section('content')
    <form action="{{ route('account.update', 1) }}" method="POST" enctype="multipart/form-data">
        @csrf
        @method('patch')
        <div class="mb-3 d-flex">
            <div class="col-6">
                <label class="form-label">Website Name</label>
                <input class="form-control" value="{{ $account->name }}" name="name">
            </div>
            <div class="col-6">
                <label class="form-label">Image</label>
                <div class="d-flex">
                    <img src="{{ $account->image }}" class="avatar avatar-sm" alt="" srcset="">
                    <input type="file" name="image" class="form-control">
                </div>
            </div>
        </div>
        <div class="mb-3">
            <label class="form-label">About</label>
            <input class="form-control" value="{{ $account->about }}" name="about">
        </div>
        <div class="mb-3">
            <label class="form-label">Fact</label>
            <input class="form-control" value="{{ $account->fact }}" name="fact">
        </div>
        <div class="mb-3">
            <label class="form-label">Skills</label>
            <input class="form-control" value="{{ $account->skills }}" name="skills">
        </div>
        <div class="mb-3">
            <label class="form-label">Resume</label>
            <input class="form-control" value="{{ $account->resume }}" name="resume">
        </div>
        <div class="mb-3">
            <label class="form-label">Portfolio</label>
            <input class="form-control" value="{{ $account->portfolio }}" name="portfolio">
        </div>
        <div class="mb-3">
            <label class="form-label">Service</label>
            <input class="form-control" value="{{ $account->service }}" name="service">
        </div>
        <div class="mb-3">
            <label class="form-label">Testimonial</label>
            <input class="form-control" value="{{ $account->testimonial }}" name="testimonial">
        </div>
        <div class="mb-3">
            <label class="form-label">Contact</label>
            <input class="form-control" value="{{ $account->contact }}" name="contact">
        </div>
        <div class="text-end">
            <button class="btn btn-success" type="submit">Submit</button>
        </div>
    </form>
    <div class="my-5">

        <form action="{{ route('about.update', 1) }}" method="POST">
            @csrf
            @method('patch')
            <div class="mb-3 d-flex">
                <div class="col-6">
                    <label class="form-label">Email</label>
                    <input class="form-control" value="{{ $about->email }}" name="email">
                </div>
                <div class="col-6">
                    <label class="form-label">Birthday</label>
                    <input class="form-control" value="{{ $about->birthday }}" name="birthday">
                </div>
            </div>
            <div class="mb-3 d-flex">
                <div class="col-6">
                    <label class="form-label">Phone</label>
                    <input class="form-control" value="{{ $about->phone }}" name="phone">
                </div>
                <div class="col-6">
                    <label class="form-label">Age</label>
                    <input class="form-control" value="{{ $about->age }}" name="age">
                </div>
            </div>
            <div class="mb-3 d-flex">
                <div class="col-6">
                    <label class="form-label">location</label>
                    <input class="form-control" value="{{ $about->location }}" name="location">
                </div>
                <div class="col-6">
                    <label class="form-label">Freelance</label>
                    <select class="form-select form-control" name="freelance">
                        <option value="1">Available</option>
                        <option value="0">Not Available</option>
                    </select>
                </div>
            </div>
            <div class="text-end">
                <button class="btn btn-success" type="submit">Submit</button>
            </div>
        </form>
    </div>
@endsection
