@extends('admin.layout.master')

@section('content')
    <div class="card">
        <div class="d-flex">
            <form action="{{ route('fact.store') }}" method="POST" class=" px-2">
                @csrf
                <label class="form-label">Bootstrap Icon</label>
                <input class="form-control" name="icon">
                <label class="form-label">Title</label>
                <input class="form-control" name="name" placeholder="fact">
                <label class="form-label">Number</label>
                <input class="form-control" name="number">
                <button type="submit" class="btn form-control btn-outline-success">Create</button>
            </form>
            <form action="{{ route('category.store') }}" method="POST" class=" px-2">
                @csrf
                <label class="form-label">Name</label>
                <input class="form-control" name="name" placeholder="category">
                <button type="submit" class="btn form-control btn-outline-success">Create</button>
            </form>
            <form action="{{ route('service.store') }}" method="POST" class=" px-2">
                @csrf
                <label class="form-label">Bootstrap Icon</label>
                <input class="form-control" name="icon">
                <label class="form-label">Name</label>
                <input class="form-control" name="name" placeholder="service">
                <label class="form-label">Description</label>
                <input class="form-control" name="description">
                <button type="submit" class="btn form-control btn-outline-success">Create</button>
            </form>
            <form action="{{ route('skill.store') }}" method="POST" class=" px-2">
                @csrf
                <label class="form-label">Skill</label>
                <input class="form-control" name="name">
                <label class="form-label">Percent</label>
                <input class="form-control" name="percent">
                <button type="submit" class="btn form-control btn-outline-success">Create</button>
            </form>
            <form action="{{ route('social.store') }}" method="POST" class=" px-2">
                @csrf
                <label class="form-label">Box Icon</label>
                <input class="form-control" name="icon">
                <label class="form-label">Link</label>
                <input class="form-control" name="link">
                <button type="submit" class="btn form-control btn-outline-success">Create</button>
            </form>
        </div>
        <hr>
        <div class="d-flex">
            <form action="{{ route('testimonial.store') }}" method="POST" class=" px-2" enctype="multipart/form-data">
                @csrf
                <label class="form-label">Name</label>
                <input class="form-control" name="name">
                <label class="form-label">Position</label>
                <input class="form-control" name="position">
                <label class="form-label">Description</label>
                <input class="form-control" name="description">
                <label class="form-label">Image</label>
                <input type="file" name="image" class="form-control">
                <button type="submit" class="btn form-control btn-outline-success">Create</button>
            </form>
            <form action="{{ route('resume.store') }}" method="POST" class=" px-2">
                @csrf
                <label class="form-label">Title</label>
                <input class="form-control" name="title">
                <label class="form-label">Year</label>
                <input class="form-control" name="year">
                <label class="form-label">University</label>
                <input class="form-control" name="university">
                <label class="form-label">Description</label>
                <input class="form-control" name="description">
                <label class="form-label">Is Education</label>
                <select class="form-select form-control" name="is_education">
                    <option value="1">Education</option>
                    <option value="0">Certification</option>
                </select>
                <button type="submit" class="btn form-control btn-outline-success">Create</button>
            </form>
            <form action="{{ route('project.store') }}" method="POST" class=" px-2" enctype="multipart/form-data">
                @csrf
                <label class="form-label">Name</label>
                <input class="form-control" name="name" placeholder="project name">
                <label class="form-label">Slug</label>
                <input class="form-control" name="slug">
                <label class="form-label">Description</label>
                <input class="form-control" name="description">
                <label class="form-label">Category</label>
                <select class="form-select form-control" name="category_id">
                    @foreach ($categories as $c)
                        <option value="{{ $c->id }}">{{ $c->name }}</option>
                    @endforeach
                </select>
                <label class="form-label">Client</label>
                <input class="form-control" name="client">
                <label class="form-label">Project Date</label>
                <input class="form-control" name="date">
                <label class="form-label">URL</label>
                <input class="form-control" name="url">
                <label class="form-label">Github</label>
                <input class="form-control" name="github">
                <label class="form-label">Image</label>
                <input type="file" name="images[]" multiple class="form-control">
                <button type="submit" class="btn form-control btn-outline-success">Create</button>
            </form>
        </div>
        <div class="d-flex px-2">

            <table class="col-4 ">
                <tr>
                    <td>No</td>
                    <td>Name</td>
                    <td>Options</td>
                </tr>
                @foreach ($categories as $key => $category)
                    <tr>
                        <td>{{ ++$key }}</td>
                        <td>{{ $category->name }}</td>
                        <td>
                            <form action="{{ route('category.destroy', $category->id) }}" method="POST">
                                @csrf
                                @method('delete')
                                <button type="submit" class="btn btn-danger">Delete</button>
                            </form>
                        </td>
                    </tr>
                @endforeach
            </table>
            <table class="col-4 ">
                <tr>
                    <td>No</td>
                    <td>Icon</td>
                    <td>Link</td>
                    <td>Options</td>
                </tr>
                @foreach ($socials as $key => $social)
                    <tr>
                        <td>{{ ++$key }}</td>
                        <td> <i class="{{ $social->icon }}"></i></td>
                        <td>{{ $social->link }}</td>
                        <td>
                            <form action="{{ route('social.destroy', $social->id) }}" method="POST">
                                @csrf
                                @method('delete')
                                <button type="submit" class="btn btn-danger">Delete</button>
                            </form>
                        </td>
                    </tr>
                @endforeach
            </table>
            <table class="col-4 ">
                <tr>
                    <td>No</td>
                    <td>Icon</td>
                    <td>Name</td>
                    <td>Number</td>
                    <td>Options</td>
                </tr>
                @foreach ($facts as $key => $fact)
                    <tr>
                        <td>{{ ++$key }}</td>
                        <td> <i class="bi {{ $fact->icon }}"></i></td>
                        <td>{{ $fact->name }}</td>
                        <td>{{ $fact->number }}</td>
                        <td>
                            <form action="{{ route('fact.destroy', $fact->id) }}" method="POST">
                                @csrf
                                @method('delete')
                                <button type="submit" class="btn btn-danger">Delete</button>
                            </form>
                        </td>
                    </tr>
                @endforeach
            </table>
        </div>
        <hr>
        <div class="d-flex px-2 ">
            <table class="col-4 ">
                <tr>
                    <td>No</td>
                    <td>Name</td>
                    <td>Percent</td>
                    <td>Options</td>
                </tr>
                @foreach ($skills as $key => $skill)
                    <tr>
                        <td>{{ ++$key }}</td>
                        <td> {{ $skill->name }}</td>
                        <td>{{ $skill->percent }}</td>
                        <td>
                            <form action="{{ route('skill.destroy', $skill->id) }}" method="POST">
                                @csrf
                                @method('delete')
                                <button type="submit" class="btn btn-danger">Delete</button>
                            </form>
                        </td>
                    </tr>
                @endforeach
            </table>
            <table class="col-4 ">
                <tr>
                    <td>No</td>
                    <td>Icon</td>
                    <td>Name</td>
                    <td>Description</td>
                    <td>Options</td>
                </tr>
                @foreach ($services as $key => $social)
                    <tr>
                        <td>{{ ++$key }}</td>
                        <td> <i class="{{ $social->icon }}"></i></td>
                        <td>{{ $social->name }}</td>
                        <td>{{ $social->description }}</td>
                        <td>
                            <form action="{{ route('service.destroy', $social->id) }}" method="POST">
                                @csrf
                                @method('delete')
                                <button type="submit" class="btn btn-danger">Delete</button>
                            </form>
                        </td>
                    </tr>
                @endforeach
            </table>
        </div>
        <hr>
        <div class="d-flex p-2">

            <table class="w-100">
                <tr>
                    <td>No</td>
                    <td>Name</td>
                    <td>Position</td>
                    <td style="width: 30%">Description</td>
                    <td>Image</td>
                    <td>Options</td>
                </tr>
                @foreach ($testimonials as $key => $data)
                    <tr>
                        <td>{{ ++$key }}</td>
                        <td>{{ $data->name }}</td>
                        <td>{{ $data->position }}</td>
                        <td>{{ $data->description }}</td>
                        <td><img src="{{ Storage::url($data->image) }}" class="avatar avatar-sm"
                                alt=""srcset=""></td>
                        <td>
                            <form action="{{ route('testimonial.destroy', $data->id) }}" method="POST">
                                @csrf
                                @method('delete')
                                <button type="submit" class="btn btn-danger">Delete</button>
                            </form>
                        </td>
                    </tr>
                @endforeach
            </table>
        </div>
        <hr>
        <div class="d-flex p-2">
            <table class="w-100">
                <tr>
                    <td>No</td>
                    <td>Title</td>
                    <td>Year</td>
                    <td>University</td>
                    <td style="width: 30%">Description</td>
                    <td>Is_education</td>
                    <td>Options</td>
                </tr>
                @foreach ($resumes as $key => $data)
                    <tr>
                        <td>{{ ++$key }}</td>
                        <td>{{ $data->title }}</td>
                        <td>{{ $data->year }}</td>
                        <td>{{ $data->university }}</td>
                        <td>{{ $data->description }}</td>
                        <td>{{ $data->is_education ? 'Education' : 'Certification' }}</td>
                        <td>
                            <form action="{{ route('resume.destroy', $data->id) }}" method="POST">
                                @csrf
                                @method('delete')
                                <button type="submit" class="btn btn-danger">Delete</button>
                            </form>
                        </td>
                    </tr>
                @endforeach
            </table>
        </div>
        <hr>
        <div class="d-flex p-2">
            <table class="w-100">
                <tr>
                    <td>No</td>
                    <td>Project name</td>
                    <td>slug</td>
                    <td>images</td>
                    <td>description</td>
                    <td>Options</td>
                </tr>
                @foreach ($projects as $key => $data)
                    <tr>
                        <td>{{ ++$key }}</td>
                        <td>{{ $data->name }}</td>
                        <td>{{ $data->slug }}</td>
                        <td>
                            @foreach ($data->projectimage as $da)
                                <img src="{{ $da->filename }}" class="avatar avatar-sm" alt=""srcset="">
                            @endforeach
                        </td>
                        <td>{{ $data->description }}</td>
                        <td>
                            <form action="{{ route('project.destroy', $data->id) }}" method="POST">
                                @csrf
                                @method('delete')
                                <button type="submit" class="btn btn-danger">Delete</button>
                            </form>
                        </td>
                    </tr>
                @endforeach
            </table>
        </div>
        <hr>
        <div class="d-flex p-2">
            <table class="w-100">
                <tr>
                    <td>No</td>
                    <td>Name</td>
                    <td>Email</td>
                    <td>Subject</td>
                    <td>Message</td>
                    <td>Options</td>
                </tr>
                @foreach ($messages as $key => $data)
                    <tr>
                        <td>{{ ++$key }}</td>
                        <td>{{ $data->name }}</td>
                        <td>{{ $data->email }}</td>
                        <td>{{ $data->subject }}</td>
                        <td>{{ $data->message }}</td>
                        <td>
                            <form action="{{ route('message.destroy', $data->id) }}" method="POST">
                                @csrf
                                @method('delete')
                                <button type="submit" class="btn btn-danger">Delete</button>
                            </form>
                        </td>
                    </tr>
                @endforeach
            </table>
        </div>
    </div>
@endsection
