<?php

namespace App\Http\Controllers;

use App\Models\Project;
use Illuminate\Http\Request;

class ProjectController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        
    $project = new Project;

    // Populate other project model attributes from the request
    $project->fill($request->except('images'));
    $project->save();

    if ($request->hasFile('images')) {
        foreach ($request->file('images') as $image) {
            
            $imageName = $image->getClientOriginalName();
            $image->storeAs('public/images',$imageName);

            $imagePath = url('storage/images/'.$imageName);
            $project->projectimage()->create(['filename' => $imagePath]);
        }
    }

    return redirect()->back();
    }

    /**
     * Display the specified resource.
     */
    public function show(Project $project, $slug)
    {
        return $project;
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Project $project)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Project $project)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Project $project)
    {
        $project->delete();
        return redirect()->back();
    }
}
