<?php

namespace App\Http\Controllers;

use App\Models\About;
use App\Models\Account;
use App\Models\Category;
use App\Models\Fact;
use App\Models\Project;
use App\Models\Resume;
use App\Models\Service;
use App\Models\Skill;
use App\Models\Social;
use App\Models\Testimonial;
use Illuminate\Http\Request;

class HomeController extends Controller
{
    public function home(){
        return view('home',[
            'account'=> Account::where('id',1)->first(),
            'about'=> About::where('id',1)->first(),
            'facts'=> Fact::all(),
            'skills'=> Skill::all(),
            'resumes'=> Resume::all(),
            'services'=> Service::all(),
            'socials'=> Social::all(),
            'testimonials'=> Testimonial::all(),
            'projects'=> Project::all(),
            'categories'=> Category::all(),
        ]);
    }

    public function pjshow($slug){
        $pj = Project::where('slug',$slug)->first();
        return view('pjdetail',[
            'socials'=> Social::all(),
            'account'=> Account::where('id',1)->first(),
            'project'=> $pj,
        ]);
    }
}
